﻿/*

"loc_langs" - the object holding all items that need localizations

In order for translations to work, the string in HTML source
should be encapsulated in a <span> with a class set to "l_"
PLUS the unique name of the sub-object containing its
translations.

For example, to translate "Install all" in HTML source, find
(or add) that sub-item in the langs object.  It already
exists with a name of "installAll".  Therefore the <span>
surrounding the text in the HTML source should be assigned a
class of "l_installAll". Example:

    <span class="l_installAll">Install all</span>

It's easy enough to add new translated strings.  Simply copy
one of the existing below, give it a unique name, and enter
the translated strings.  Then add the "l_" + unique name
class to a <span> around the original string in the HTML
source.
*/

loc_supportedLangs = [
"en", // English
"ptb", // Portuguese (Brazilian)
"de", // German
"fr", // French
"es", // Spanish
"it", // Italian
"ko", // Korean
"jp", // Japanese
"ch", // Chinese (Simplified)
];

loc_langs = {


  thanks: {
    en: '新秀网 xinxiuz.com 互联网分享精神',
    ptb: '新秀网 xinxiuz.com 互联网分享精神',
    de: '新秀网 xinxiuz.com 互联网分享精神',
    fr: '新秀网 xinxiuz.com 互联网分享精神',
    es: '新秀网 xinxiuz.com 互联网分享精神',
    it: '新秀网 xinxiuz.com 互联网分享精神',
    ko: '新秀网 xinxiuz.com 互联网分享精神',
    jp: '新秀网 xinxiuz.com 互联网分享精神',
    ch: '新秀网 xinxiuz.com 互联网分享精神',
  },

  getStarted: {
    en: '主题社 www.zhutishe.net',
    ptb: '主题社 www.zhutishe.net',
    de: '主题社 www.zhutishe.net',
    fr: '主题社 www.zhutishe.net',
    es: '主题社 www.zhutishe.net',
    it: '主题社 www.zhutishe.net',
    ko: '主题社 www.zhutishe.net',
    jp: '主题社 www.zhutishe.net',
    ch: '主题社 www.zhutishe.net',
  },

  compareText: {
    en: 'Text',
    ptb: 'Texto',
    de: 'Text',
    fr: 'Texte',
    es: 'Texto',
    it: 'Testo',
    ko: '텍스트',
    jp: 'テキスト',
    ch: '文本',
  },

  compare3text: {
    en: '3-way text',
    ptb: 'Texto de 3 vias',
    de: '3-fach-Text',
    fr: '3 fichiers texte',
    es: 'Texto de 3 vías',
    it: 'Testo 3-Way',
    ko: '3개 텍스트 모드',
    jp: '<span style="font-size: 90%;">3-Wayテキストモード</span>',
    ch: '三方文本',
  },

  compareDoc: {
    en: 'Doc',
    ptb: 'Doc',
    de: 'Dokument',
    fr: 'Doc',
    es: 'Doc',
    it: 'Doc',
    ko: '문서',
    jp: 'ドキュメント',
    ch: '文档',
  },

  comparePdf: {
    en: 'PDF',
    ptb: 'PDF',
    de: 'PDF',
    fr: 'PDF',
    es: 'PDF',
    it: 'PDF',
    ko: 'PDF',
    jp: 'PDF',
    ch: 'PDF',
  },

  compareFolder: {
    en: 'Folder',
    ptb: 'Pasta',
    de: 'Ordner',
    fr: 'Dossier',
    es: 'Carpeta',
    it: 'Cartella',
    ko: '폴더',
    jp: 'フォルダモード',
    ch: '文件夹',
  },

  compare3folder: {
    en: '3-way folder',
    ptb: 'Pasta de 3 vias',
    de: '3-fach-Ordner',
    fr: '3 dossiers',
    es: '<span style="font-size: 85%;">Carpetas de 3-Vías</span>',
    it: 'Cartelle 3-Way',
    ko: '3개 폴더 모드',
    jp: '<span style="font-size: 85%;">3-Way フォルダモード</span>',
    ch: '三方文件夹',
  },

  compareTable: {
    en: 'Table',
    ptb: 'Tabela',
    de: 'Tabelle',
    fr: 'Table',
    es: 'Tabla',
    it: 'Tabella',
    ko: '문자표',
    jp: 'テーブル',
    ch: '表格',
  },

  compareBinary: {
    en: 'Binary (smart)',
    ptb: '<span style="font-size: 85%;">Binário (inteligente)</span>',
    de: 'Binär (intelligent)',
    fr: '<span style="font-size: 90%;">Binaire (intelligent)</span>',
    es: '<span style="font-size: 87%;">Binario (inteligente)</span>',
    it: '<span style="font-size: 85%;">Binaria (intelligente)</span>',
    ko: '바이너리 (스마트)',
    jp: '<span style="font-size: 90%;">バイナリ（スマート)</span>',
    ch: '二进制(智能)',
  },

  compareBinaryFast: {
    en: 'Binary (fast)',
    ptb: 'Binário (rápido)',
    de: 'Binär (schnell)',
    fr: '<span style="font-size: 90%;">Binaire (rapide)</span>',
    es: '<span style="font-size: 87%;">Binario (rápido)</span>',
    it: '<span style="font-size: 90%;">Binaria (veloce)</span>',
    ko: '바이너리 (빠른)',
    jp: 'バイナリ(高速)',
    ch: '二进制(快速)',
  },

  compareArchive: {
    en: 'Zip/Rar/Jar',
    ptb: 'Zip/Rar/Jar',
    de: 'Zip/Rar/Jar',
    fr: 'Zip/Rar/Jar',
    es: 'Zip/Rar/Jar',
    it: 'Zip/Rar/Jar',
    ko: 'Zip/Rar/Jar',
    jp: 'Zip/Rar/Jar',
    ch: 'Zip/Rar/Jar',
  },

  compareGitMerge: {
    en: 'Resolve conflicts',
    ptb: 'Resolver conflitos',
    de: 'Konflikte auflösen',
    fr: '<span style="font-size: 87%;">Résoudre des conflits</span>',
    es: 'Resolver conflictos',
    it: 'Risolvi conflitti',
    ko: '충돌 해결',
    jp: '衝突を解決',
    ch: '解决冲突',
  },

  compareGitVersion: {
    en: 'Diff versions',
    ptb: 'Versões diferentes',
    de: '<span style="font-size: 75%;">Versionen vergleichen</span>',
    fr: '<span style="font-size: 70%;">Versions de différenciation</span>',
    es: '<span style="font-size: 75%;">Diferencias de versiones</span>', // Original: 'Comparar diferencias de versiones',
    it: '<span style="font-size: 75%;">Confronta (diff) versioni</span>',  
    ko: '다른 버전',
    jp: '相違バージョン',
    ch: '差异版本',
  },

};